<?php

/** 
 * Определим переменную корня нашего приложения
 */
define('ROOT', realpath('.'));

/**
 * Определим переменную системного каталога приложения
 */
define('APP_PATH', ROOT . '/app');

/**
 * Путь, где находится файл настроек приложения
 */
define('APP_CONFIG_PATH', __DIR__);

/**
 * Путь ядра приложения
 */
define('KERNEL_PATH', APP_PATH . '/kernel');

// Автозагрузчик классов
$LOADER = require APP_PATH . '/autoload.php';
 
/**
 * Возвращаемый массив настроек для работы приложения
 * 
 * Внимание! Крайне не рекомендуется удалять/изменять
 * что-либо, если Вы точно не знаете, что за этим последует.
 */
return array(
    // Ветвь для подключения БД
    'db' => array(
        'host' => '#host#',	// адрес MySQL хоста
		'port' => '#port#',	// номер порта для подключения
        'user' => '#user#',	// имя пользователя БД
        'pass' => '#pass#',	// пароль пользователя БД
        'name' => '#name#'	// название БД
    ),
    
    // Ветвь для отладки приложения
    // Функционал рекомендован чисто для разработки
    'debug' => array(
        'enable' => true, // принимает 2 значения (true|false). При отключении будут проигнорированы все настройки кроме logfile-файла
        'db_debug' => false, // принимает 2 значений (true|false). При включенном состоянии показывает диагностические сообщения работы sql
        'register_errors_all' => 0, // показывать абсолютно все ошибки и предупреждения(1), или с ограничениями(0)
        'display_errors' => 1, // Показывать ли выводимые сообщения об ошибках на экран(1) или в файл(0)
        'error_log' => __DIR__ . '/php_error.log', // Куда будут сохраняться сообщения об ошибках        
        //'logfile' => __DIR__ . '/work.log' // куда будут записываться сообщения и другие данные о работе приложения. @todo!!!
    ),    
    
    // Здесь определяем какую тему применить
    'theme' => 'utest',
    
    // Также можно настроить "карту" применяемых шаблонов для страниц.
    // "Карта" настраивается только для url компонентов, если необходимо настроить
    // шаблон для произвольного url-адреса, то прежде его нужно зарегистрировать
    // в списке URL алиасов!
    // Внимание! При настройке "карты" нужно помнить, что элемент с ключом 
    // '*' (звёздочка) является обязательным - считается шаблоном по умолчанию!
    'tplMap' => array(
        '*' => 'inner',   
        '/' => 'main',
        // можно продолжать список, определяя для каждого url-адреса свой шаблон
        // к примеру запись: 
        // ...
        // '/root/example' => 'my_template'
        // ...
        // будет означать, что при запросе страницы "/root/example" будет подгружен
        // шаблон "my_template" из выбранной выше темы <theme>
    ),
    
    // Список URL алиасов
    // Ключом должен быть путь страницы от корня сайта (пример: "/root/example")
    // Каждый алиас должен быть описан массивом, состоящий из 2-х элементов:
    // 1-й: имя компонента (обязательный). Можно также установить в false, если необходимо просто закрепить алиас для пользовательского шаблона
    // 2-й: доступ только авторизованным пользователям или всем (необязательный, по умолчанию true - только авторизованным)
    'urlAliases' => array(
        // ...
        //'/test' => array('test', false)
        // ...
        // данный пример будет означать, что при запросе страницы "/test" будет
        // загружен компонент "test", при этом страница будет доступна всем
        // 
        // Внимание! Переопределение системных алиасов на пользовательские или же
        // определение компонетов, зависящих от типа пользователя (авторизации),
        // к пользовательским алиасам может иметь непредсказуемый исход! 
        // Будьте внимательны!
    )
);

